/*
 * 作成日: 2005/07/10
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Common Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.form;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ext.s2jdbc.CodeGenerator;
import zigen.plugin.db.ext.s2jdbc.entity.rule.DefaultEntityMappingFactory;
import zigen.plugin.db.ext.s2jdbc.entity.rule.IEntityMappingFactory;
import zigen.plugin.db.ext.s2jdbc.util.PropertyNameUtil;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.TreeLeaf;

/**
 * S2JDBC EntityCreator.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/10 ZIGEN create.
 * 
 */
public class FormGenerator extends CodeGenerator {
	
	private String prefix = "Form"; //$NON-NLS-1$
	
	private ITable table;
	
	private TreeLeaf[] leafs;
	
	boolean underLineCut = true;
	
	String accessModifiers = "public"; // 初期値 public //$NON-NLS-1$
	
	IEntityMappingFactory mapping;
	
	public FormGenerator(ITable table) {
		this.table = table;
		this.leafs = table.getChildrens();
		this.mapping = DefaultEntityMappingFactory.getFactory(table.getDbConfig());
	}
	
	// プロパティ定義
	private void do_property() {
		for (int i = 0; i < leafs.length; i++) {
			Column col = (Column) leafs[i];
			
			println("\t/**"); //$NON-NLS-1$
			println("\t * " + col.getLogicalColumnLabel()); //$NON-NLS-1$
			println("\t */"); //$NON-NLS-1$
			
			if (col.hasPrimaryKey() || col.isNotNull()) {
				println("\t@Required");
			}
			
			if (col.getRemarks() != null && !"".equals(col.getRemarks())) {
				println("\t@Label(\"" + col.getRemarks() + "\")");
			} else {
				println("\t@Label(\"" + col.getName() + "\")");
			}
			
			println("\t" + propertyString(accessModifiers, getJavaType(col), PropertyNameUtil.getProperty(col, underLineCut))); //$NON-NLS-1$
			println();
		}
	}
	
	private void do_import() {
		println("import java.io.Serializable;"); //$NON-NLS-1$
		println();
		println("import org.seasar.framework.container.annotation.tiger.Component;");
		println("import org.seasar.framework.container.annotation.tiger.InstanceType;");
		println("import org.seasar.struts.annotation.Required;");
		println();
	}
	
	private void do_classBegin() {
		println("@Component(instance = InstanceType.SESSION)");
		println("public class " + getClassName() + " implements Serializable{"); //$NON-NLS-1$ //$NON-NLS-2$
		println();
		
		// for Serializable
		println("\tprivate static final long serialVersionUID = 1L;");
		println();
	}
	
	private void do_classEnd() {
		println("}"); //$NON-NLS-1$
	}
	
	public void execute() {
		super.setGenerateInfo();
		do_import();
		super.setClassComment();
		do_classBegin();
		do_property();
		do_toString();
		do_classEnd();
		do_sample();
	}
	
	public String getClassName() {
		String str = table.getName();
		StringBuffer sb = new StringBuffer();
		sb.append(str.substring(0, 1).toUpperCase());
		sb.append(str.substring(1, str.length()).toLowerCase());
		sb.append(prefix); // prefix(VO)
		return sb.toString();
	}
	
	private void do_toString() {
		String[] properties = new String[leafs.length];
		for (int i = 0; i < leafs.length; i++) {
			Column col = (Column) leafs[i];
			properties[i] = PropertyNameUtil.getProperty(col, underLineCut);
		}
		println(toStringString(getClassName(), properties));
	}
	
	private String getJavaType(Column col) {
		TableColumn tCol = col.getColumn();
		// return mapping.getJavaType(tCol);
		return "String";
	}
	
	private boolean hasPrimaryKey() {
		for (int i = 0; i < leafs.length; i++) {
			Column col = (Column) leafs[i];
			TablePKColumn pkColumn = col.getPkColumn();
			if (pkColumn != null) {
				return true;
			}
		}
		return false;
	}
	
	private void do_sample() {
		println("/* samle code for JSP"); //$NON-NLS-1$
		for (int i = 0; i < leafs.length; i++) {
			Column col = (Column) leafs[i];
			println("<fj:text property=\"" + PropertyNameUtil.getProperty(col, underLineCut) + "\"/>");
			
		}
		println("*/");
	}
	
}
